# -*- coding: utf-8 -*-
"""r15.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1qZlTzjXzRJ9u4jdWX-_YfzWsvVlwWMuL
"""

import numpy as np
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

import pandas as pd
import seaborn as sns

# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Rysunek 1."""

X = np.random.randn(1000,2)
X[:,1] = np.sum(X,axis=1)

evals,evecs = np.linalg.eig( np.cov(X.T,ddof=1) )
scores = X @ evecs


_,axs = plt.subplots(1,2,figsize=(10,5))
axs[0].plot(X[:,0],X[:,1],'ko',markerfacecolor='w')
axs[0].plot([0,3*evecs[0,1]],[0,3*evecs[1,1]],'r-',linewidth=4,label='PC1')
axs[0].plot([0,3*evecs[0,0]],[0,3*evecs[1,0]],'r:',linewidth=4,label='PC2')
axs[0].axis([-5,5,-5,5])
axs[0].set_xlabel('Pierwsza cecha')
axs[0].set_ylabel('Druga cecha')
axs[0].legend()
axs[0].set_title('Dane w przestrzeni cech')


axs[1].plot(scores[:,1],scores[:,0],'ko',markerfacecolor='w')
axs[1].set_xlabel('Pierwsza główna składowa')
axs[1].set_ylabel('Druga główna składowa')
axs[1].axis([-6,6,-6,6])
axs[1].set_title('Dane w przestrzeni głównych składowych')

plt.tight_layout()
plt.savefig('rys15.1.png',dpi=300, bbox_inches='tight')
plt.show()

"""# Równość kwadratu normy i wariancji"""

q = X[:,1]

var = np.var(q,ddof=1)

norm = np.linalg.norm( q-np.mean(q) )**2

print(var)
print(norm / (len(q)-1))



"""# Ćwiczenie 1. (PCA danych z giełdy w Stanbule)"""

# Źródło: Akbilgic, Oguz. (2013). ISTANBUL STOCK EXCHANGE. UCI Machine Learning Repository.
# https://archive-beta.ics.uci.edu/ml/datasets/istanbul+stock+exchange

# import danych
url = "https://archive.ics.uci.edu/ml/machine-learning-databases/00247/data_akbilgic.xlsx"
data = pd.read_excel(url,index_col=0,skiprows=1)

data

# wykreślam część danych na wykresie
data.plot(figsize=(15,6),ylabel='Stopa zwrotu')
plt.xlabel('Data')
plt.savefig('rys15.3a.png',dpi=300)
plt.show()

# wykres typu pairplot z pakietu Seaborn pokazuje wiele dodatnich korelacji
# nie zamieściłem go w książce, bo jest za duży
sns.pairplot(data,height=1.5)
plt.show()

### macierz korelacji w postaci obrazka

plt.figure(figsize=(8,8))
heatmap = sns.heatmap(data.corr(),vmin=-1,vmax=1,annot=True,cmap='bwr')
plt.savefig('rys15.3b.png',dpi=300, bbox_inches='tight')
plt.show()

#### czas na PCA!

# krok 1.: macierz kowariancji
X = data.values # ekstrakcja danych
X = X - np.mean(X,axis=0,keepdims=True) # wyśrodkowanie

# uwaga: dane to obserwacje względem cech, a zatem potrzebujemy  X'X, a nie XX'
covmat = X.T@X / (X.shape[0]-1)

# wizualizacja
plt.figure(figsize=(6,6))
plt.imshow(covmat,vmin=-.0002,vmax=.0002)
plt.colorbar(shrink=.82)
plt.xticks(range(X.shape[1]),labels=data.columns,rotation=90)
plt.yticks(range(X.shape[1]),labels=data.columns)
plt.savefig('rys15.3c.png',dpi=300, bbox_inches='tight')
plt.show()

# krok 2.: rozkład według wartości własnych
evals,evecs = np.linalg.eig(covmat)

# krok 3.: sortowanie wyników
sidx  = np.argsort(evals)[::-1]
evals = evals[sidx]
evecs = evecs[:,sidx]


# krok 4.: istotności składowych
components = data.values @ evecs[:,0:2]
print(components.shape)

# krok 5.: zamiana wartości własnych na procent wyjaśnianej wariancji
factorScores = 100*evals/np.sum(evals)


# wykres osypiska
plt.figure(figsize=(8,4))
plt.plot(factorScores,'ks-',markersize=15)
plt.xlabel('Numer składowej')
plt.ylabel('Procent wyjaśnianej wariancji')
plt.title('Wykres osypiska danych giełdowych')
plt.grid()
plt.show()

print('Wariancja pierwszych dwóch składowych:')
print(np.var(components,axis=0,ddof=1)) # uwaga na ddof=1! Domyślnie zwracana jest wariancja z biasem

print(f'\nPierwsze dwie wartości własne:')
print(evals[:2])

# korelacja pierwszych dwóch składowych

plt.figure(figsize=(12,6))
plt.plot(components)
plt.xlabel('Czas (dni)')
plt.legend(['Pierwsza składowa','Druga składowa'])
plt.title(f'Korelacja r={np.corrcoef(components.T)[0,1]:.5f}')
plt.show()

_,axs = plt.subplots(1,2,figsize=(12,5))

for i in range(2):
  axs[i].bar(range(X.shape[1]),evecs[:,i],color='black')
  axs[i].set_xticks(range(X.shape[1]))
  axs[i].set_xticklabels(data.columns,rotation=45)
  axs[i].set_ylabel('Waga')
  axs[i].set_title(f'Wagi dla składowej numer {i}')

plt.tight_layout()
plt.show()

# wszystko na jednym wykresie

fig = plt.figure(figsize=(10,6))
gs = GridSpec(2,4,figure=fig)

# wykres osypiska
ax1 = fig.add_subplot(gs[0,0])
ax1.plot(factorScores,'ks-',markersize=10)
ax1.set_xlabel('Numer składowej')
ax1.set_ylabel('Procent wyjaśnianej wariancji')
ax1.set_title('Wykres osypiska')
ax1.grid()

# szereg czasowy składowych
ax2 = fig.add_subplot(gs[0,1:])
ax2.plot(components)
ax2.set_xlabel('Czas (dni)')
ax2.set_xlim([0,components.shape[0]])
ax2.legend(['Pierwsza składowa','Druga składowa'])
ax2.set_title(f'Korelacja r={np.corrcoef(components.T)[0,1]:.5f}')


# wykres słupkowy
axs = fig.add_subplot(gs[1,:2]), fig.add_subplot(gs[1,2:])
for i in range(2):
  axs[i].bar(range(X.shape[1]),evecs[:,i],color='black')
  axs[i].set_xticks(range(X.shape[1]))
  axs[i].set_xticklabels(data.columns,rotation=45)
  axs[i].set_ylabel('Waga')
  axs[i].set_title(f'Wagi dla składowej numer {i}')

plt.tight_layout()
plt.savefig('rys15.4.png',dpi=300, bbox_inches='tight')
plt.show()



"""# Ćwiczenie 2."""

### rozkład macierzy kowariancji według wartości osobliwych

# wystarczy pokazać zgodność wartości własnych i osobliwych oraz zgodność wektorów własnych i osobliwych
# zrobię to dla pierwszych czterech wartości i pierwszych wektorów
# rozkład według wartości osobliwych
U,s,Vt = np.linalg.svd(covmat)

# wartości własne/osobliwe
print('Pierwsze 4 wartości własne:')
print(evals[:4])

print(f'\nPierwsze 4 wartości osobliwe:')
print(s[:4])


# wektory własne/osobliwe
print('\n\n\nPierwszy wektor własny:')
print(evecs[:,0])

print('\nPierwszy wektor osobliwy:')
print(U[:,0])

### # rozkład według wartości osobliwych

# ponownie wystarczy pokazać zgodność wartości własnych i osobliwych oraz zgodność wektorów własnych i osobliwych
# uwaga dane w X są już wycentrowane!

U,s,Vt = np.linalg.svd(X)  # rozkład według wartości osobliwych



# wartości własne/osobliwe
print('Pierwsze 4 wartości własne:')
print(evals[:4])

print(f'\nPierwsze 4 wartości osobliwe:')
print(s[:4]**2/(X.shape[0]-1))


# wektory własne/osobliwe
print('\n\n\nPierwszy wektor własny:')
print(evecs[:,0])

print('\nPierwszy prawostronny wektor osobliwy:')
print(Vt[0,:])



"""# Ćwiczenie 3."""

# ponownie wystarczy pokazać zgodność wartości własnych i osobliwych oraz zgodność wektorów własnych i osobliwych

from sklearn.decomposition import PCA

pca = PCA()
X_t = pca.fit_transform(data)

# wartości własne
print('Wartości własne:')
print(evals[:4])

print(f'\nWyjaśniania wariancja z sklearn:')
print(pca.explained_variance_[:4])


# wektory własne
print('\n\n\nPierwszy wektor własny:')
print(evecs[:,0])

print('\nPierwsza składowa z sklearn:')
print(pca.components_[0,:])



"""# Ćwiczenie 4."""

# generowanie danych

x = np.hstack((np.random.randn(1000,1),.05*np.random.randn(1000,1)))

# macierze rotacji
th = -np.pi/6
R1 = np.array([ [np.cos(th), -np.sin(th)],
                [np.sin(th),  np.cos(th)] ])
th = -np.pi/3
R2 = np.array([ [np.cos(th), -np.sin(th)],
                [np.sin(th),  np.cos(th)] ])

# tworzę dane
X = np.vstack((x@R1,x@R2))
X.shape

# PCA za pomocą rozkładu według wartości osobliwych

U,s,Vt = np.linalg.svd(X-np.mean(X,axis=0,keepdims=True))

# nie wymagane: zamiana wartości osobliwych na własne
s = s**2 / (X.shape[0]-1)

# również nie wymagane: przeskalowanie wartości na potrzeby wizualizacji
Vt *= 2

# wykreślam dane i wektory własne

plt.figure(figsize=(7,7))

# dane
plt.plot(X[:,0],X[:,1],'ko',markerfacecolor='w')

# wektory własne
plt.plot([0,Vt[0,0]],[0,Vt[1,0]],'r--',linewidth=5,label='Pierwsza składowa')
plt.plot([0,Vt[0,1]],[0,Vt[1,1]],'r:',linewidth=5,label='Druga składowa')

plt.legend()
plt.grid()
plt.savefig('rys15.5.png',dpi=300)
plt.show()



"""# Ćwiczenie 5."""

# tworzę dane
N = 200

class1 = np.random.randn(N,2)
class1[:,1] += class1[:,0]
class1 += np.array([2,-1])

class2 = np.random.randn(N,2)
class2[:,1] += class2[:,0]

# na później, warto zapisać dane w macierzy
alldata = np.vstack((class1,class2))
labels  = np.append(np.zeros(N),np.ones(N))



# wykreślam dane w oryginalnej przestrzeni
ax = sns.jointplot(x=alldata[:,0],y=alldata[:,1],hue=labels)
ax.ax_joint.set_xlabel('Pierwsza oś danych')
ax.ax_joint.set_ylabel('Druga oś danych')
ax.plot_joint(sns.kdeplot)
plt.savefig('rys15.2a.png',dpi=300, bbox_inches='tight')
plt.show()



"""# Ćwiczenie 6."""

# Liniowa analiza dyskryminacyjna

# kowariancja między klasami
cmc1 = np.mean(class1,axis=0)
cmc2 = np.mean(class2,axis=0)
covB = np.cov(np.vstack((cmc1,cmc2)).T,ddof=1)

# kowariancja wewnątrz klas
cov1 = np.cov(class1.T,ddof=1)
cov2 = np.cov(class2.T,ddof=1)
covW = (cov1+cov2)/2


from scipy.linalg import eigh
evals,evecs = eigh(covB,covW)

# sortowanie wyniku
sidx  = np.argsort(evals)[::-1]
evals = evals[sidx]
evecs = evecs[:,sidx]


# rzutowanie wycentrowanych danych na osie z uogólnionego rozkładu według wartości własnych
projA = (alldata-np.mean(alldata,axis=0)) @ evecs  # A=all

# wykres
_,axs = plt.subplots(1,2,figsize=(12,6))
marker = ['bo','r+']
for i in range(2):
  axs[0].plot(alldata[labels==i,0],alldata[labels==i,1],marker[i],label=f'Klasa {i}')

axs[0].plot([0,evecs[0,0]],[0,evecs[1,0]],'k-',linewidth=3,label='C1')
axs[0].plot([0,evecs[0,1]],[0,evecs[1,1]],'k:',linewidth=3,label='C2')
axs[0].set_xlabel('Pierwsza oś danych')
axs[0].set_ylabel('Druga oś danych')
axs[0].set_title('Dane w przestrzeni zmiennych')



# ponownie przestrzeń uogólnionego rozkładu według wartości własnych
for i in range(2):
  axs[1].plot(projA[labels==i,0],projA[labels==i,1],marker[i],label=f'Klasa {i}')
axs[1].set_xlabel('Pierwsza oś')
axs[1].set_ylabel('Druga oś')
axs[1].set_title('Dane w przestrzeni uogólnionego\nrozkładu według wartości własnych')


for i in range(2):
  axs[i].axis([-6,6,-6,6])
  axs[i].grid()
  axs[i].legend()

plt.tight_layout()
plt.savefig('rys15.6ab.png',dpi=300, bbox_inches='tight')
plt.show()

# predykcja
predictedLabel = ( projA[:,0] > 0 )+0

print(f'Dokładność predykcji: {100*np.mean( predictedLabel==labels )}%')

# wykres
plt.figure(figsize=(12,5))
plt.plot(predictedLabel,'ks',markersize=7,markerfacecolor='w',linewidth=2)
plt.plot([N-.5,N-.5],[-.5,1.5],'k--')
plt.xlabel('Numer próbki')
plt.ylabel('Przewidywana klasa')
plt.yticks([0,1],labels=['Klasa 0','Klasa 1'])
plt.title(f'Dokładność = {100*np.mean(predictedLabel==labels):.2f}%')
plt.savefig('rys15.6c.png',dpi=300)
plt.show()

# połączony wykres w przestrzeni uogólnionego rozkładu według wartości własnych (rys15.2)
ax = sns.jointplot(x=projA[:,0],y=projA[:,1],hue=labels,xlim=[-6,6],ylim=[-6,6])
ax.ax_joint.set_xlabel('Pierwsza oś z liniowej analizy dyskryminacyjnej')
ax.ax_joint.set_ylabel('Druga oś z liniowej analizy dyskryminacyjnej')
ax.plot_joint(sns.kdeplot)
plt.savefig('rys15.2b.png',dpi=300, bbox_inches='tight')
plt.show()



"""# Ćwiczenie 7."""

# to nie jest macierz jednostkowa!
print("V'V:")
print(np.round( evecs.T @ evecs ,3))


# to jest macierz jednostkowa!
print(f"\nV'RV:")
print(np.round( evecs.T @ covW @ evecs ,3))



"""# Ćwiczenie 8."""

from sklearn.discriminant_analysis import LinearDiscriminantAnalysis as LDA

ldamodel = LDA(solver='eigen')
ldamodel.fit(alldata,labels)


# wykres
plt.figure(figsize=(12,5))
plt.plot(predictedLabel,'ks',markersize=7,markerfacecolor='w',linewidth=2,label='Własna implementacja')
plt.plot(ldamodel.predict(alldata),'r+',markersize=10,markerfacecolor='w',linewidth=2,label='Implementacja z sklearn ')
plt.plot([N-.5,N-.5],[-.5,1.5],'k--')
plt.xlabel('Numer próbki')
plt.ylabel('Przewidywana klasa')
plt.yticks([0,1],labels=['Klasa 0','Klasa 1'])
plt.ylim([-.5,1.5])
plt.legend()
plt.title(f'Dokładność = {100*np.mean(ldamodel.predict(alldata)==labels):.2f}%')
plt.savefig('rys15.7.png',dpi=300)
plt.show()



"""# Ćwiczenie 9."""

shrinkage = np.linspace(0,1,21)
accuracies = np.zeros(len(shrinkage))

# pętla po współczynnikach i obliczenia dokładności
for i,s in enumerate(shrinkage):

  # przygotowanie modelu
  ldamodel = LDA(solver='eigen',shrinkage=s)

  tmpacc = []
  for _ in range(50):

    # losowy podział na zbiór uczący i testowy
    randorder = np.random.permutation(alldata.shape[0])

    # dopasowanie modelu do danych uczących
    ldamodel.fit(alldata[randorder[:350],:],labels[randorder[:350]])

    # dokładność
    tmpacc.append(100*np.mean(ldamodel.predict(alldata[randorder[350:],:])==labels[randorder[350:]]))

  # ewaluacja modelu na danych testowych
  accuracies[i] = np.mean(tmpacc)


# wykres
plt.figure(figsize=(8,5))
plt.plot(shrinkage,accuracies,'ks-',markersize=10,markerfacecolor='w',linewidth=2)
plt.xlabel('Stopień regularyzacji')
plt.ylabel('Dokładność w zbiorze testowym')
plt.title('Regularyzacja metodą shrinkage\nWydajność modelu a stopień regularyzacji')
plt.savefig('rys15.8.png',dpi=300)
plt.show()



"""# Ćwiczenie 10."""

from skimage import io,color
url = 'https://upload.wikimedia.org/wikipedia/ka/1/1c/Stravinsky_picasso.png'

# import obrazków i przeniesienie ich do dwuwymiarowej przestrzeni
strav = io.imread(url)
strav = color.rgb2gray(strav)

plt.figure(figsize=(8,8))
plt.imshow(strav,cmap='gray')
plt.title(f'Rozmiar macierzy: {strav.shape}, rząd: {np.linalg.matrix_rank(strav)}')
plt.show()

# rozkład według wartości osobliwych
U,s,Vt = np.linalg.svd(strav)
S = np.zeros_like(strav)
np.fill_diagonal(S,s)

# wykres osypiska
plt.figure(figsize=(12,4))
plt.plot(s[:30],'ks-',markersize=10)
plt.xlabel('Numer składowej')
plt.ylabel('Wartość osobliwa')
plt.title('Wykres osypiska dla rysunku Strawinskiego')
plt.grid()
plt.show()

fig = plt.figure(figsize=(9,9))
gs = GridSpec(3,4,figure=fig)

# obrazek
ax1 = fig.add_subplot(gs[0,0])
ax1.imshow(strav,cmap='gray')
ax1.set_title(f'Rozmiar macierzy:\n{strav.shape},\nrząd: {np.linalg.matrix_rank(strav)}')

# wykres osypiska
ax2 = fig.add_subplot(gs[0,1:])
ax2.plot(s[:30],'ks-',markersize=10)
ax2.set_xlabel('Numer składowej')
ax2.set_ylabel('Wartość osobliwa')
ax2.set_title('Wykres osypiska dla rysunku Strawinskiego')
ax2.grid()


## wyświetlam osobno pierwsze N "warstw"
numLayers = 4
rank1mats = np.zeros((numLayers,strav.shape[0],strav.shape[1]))


# pętla
for i in range(numLayers):

    # tworzę warstwę
    rank1mats[i,:,:] = np.outer(U[:,i],Vt[i,:])*s[i]

    # wyświetlam warstwę
    ax = fig.add_subplot(gs[1,i])
    ax.imshow(rank1mats[i,:,:],cmap='gray')
    ax.set_title(f'L {i}')
    ax.set_xticks([]), ax.set_yticks([])

    # wyświetla skumulowaną sumę warstw
    ax = fig.add_subplot(gs[2,i])
    ax.imshow(np.sum(rank1mats[:i+1,:,:],axis=0),cmap='gray')
    ax.set_title(f'L 0:{i}')
    ax.set_xticks([]), ax.set_yticks([])


plt.tight_layout()
plt.savefig('rys15.9.png',dpi=300, bbox_inches='tight')
plt.show()



"""# Ćwiczenie 11."""

# rekonstrukcja na podstawie pierwszych k warstw

# liczba skladowych
k = 80

# rekonstrukcja
stravRec = U[:,:k] @ S[:k,:k] @ Vt[:k,:]


# wykres
_,axs = plt.subplots(1,3,figsize=(15,6))

axs[0].imshow(strav,cmap='gray',vmin=.1,vmax=.9)
axs[0].set_title('Oryginalny obrazek')

axs[1].imshow(stravRec,cmap='gray',vmin=.1,vmax=.9)
axs[1].set_title(f'Rekonstrukcja (k={k}/{len(s)})')

axs[2].imshow((strav-stravRec)**2,cmap='gray',vmin=0,vmax=1e-1)
axs[2].set_title('Kwadraty błędów')

plt.tight_layout()
plt.savefig('rys15.10.png',dpi=300, bbox_inches='tight')
plt.show()

# obliczam rozmiary obrazków
stravSize  = strav.nbytes / 1024**2
stravRSize = stravRec.nbytes / 1024**2

# i wektorów/wartości osobliwych
uSize = U[:,:k].nbytes / 1024**2
sSize = s[:k].nbytes / 1024**2
vSize = Vt[:k,:].nbytes / 1024**2


# wyświetlam wyniki
print(f'                          Oryginalny obraz ma {stravSize:.2f} MB')
print(f'                   Jego rekonstrukcja zajmuje {stravRSize:.2f} MB')
print(f'Wektory potrzebne do jego odtworzenia zajmują {uSize+sSize+vSize:.2f} MB (korzystam z k={k} składowych)')

print(f'\n                           Stopień kompresji: {100*(uSize+sSize+vSize)/stravSize:.2f}%')



"""# Ćwiczenie 12."""

# zakres numerów składowych
k = range(1,len(s)+1)

# inicjalizacja zmiennej do przechowywania wyniku
kError = np.zeros(len(k))


# pętla
for i in range(len(k)):

  # rekonstrukcja
  stravRec = U[:,:k[i]] @ S[:k[i],:k[i]] @ Vt[:k[i],:]

  # obliczam i zapisuje błąd
  kError[i] = np.sqrt(np.sum((strav-stravRec)**2))



# wykreślam wyniki
plt.figure(figsize=(10,7))
plt.plot(k,kError,'ks-')
# plt.plot(k[:-1],np.diff(kError),'ks-') # odkomentuj, aby pokazać pochodną (i zakomentuj poprzednią linię)
plt.xlabel('Rząd rekonstrukcji')
plt.ylabel('Błąd w stosunku do oryginału')
plt.title('Dokładność rekonstrukcji')
plt.savefig('rys15.11.png',dpi=300)
plt.show()



"""# Ćwiczenie 13."""

# tworzę przestrzennego sinusa

# fazy
sinefreq = .02   # arbitralna wartość
sinephas = np.pi/6 # kąt obrotu

# inicjalizacja sinusa
[x,y] = np.meshgrid(np.linspace(-100,100,strav.shape[1]),
                    np.linspace(-100,100,strav.shape[0]))
xp    = x*np.cos(sinephas) + y*np.sin(sinephas)


# fala
sinimg = np.sin( 2*np.pi*sinefreq*xp)

# przeskalowanie do zakresu [0 1]
sinimg = (sinimg-np.min(sinimg)) / (np.max(sinimg)-np.min(sinimg))


# dodaję sinusa do rysunku Strawinskiego i przeskalowuję wynik
stravNoise = strav + sinimg
stravNoise = stravNoise-np.min(stravNoise)
stravNoise = stravNoise/np.max(stravNoise)

# zobaczmy, jak to wygląda!
_,axs = plt.subplots(1,3,figsize=(10,7))
axs[0].imshow(strav,cmap='gray')
axs[0].set_title('Oryginalny obrazek')

axs[1].imshow(sinimg,cmap='gray')
axs[1].set_title('Szum')

axs[2].imshow(stravNoise,cmap='gray')
axs[2].set_title('Zaszumiony obrazek')

plt.tight_layout()
plt.savefig('rys15.12.png',dpi=300)
plt.show()

# rozkład według wartości osobliwych
Un,sn,Vtn = np.linalg.svd(stravNoise)
Sn = np.zeros_like(stravNoise)
np.fill_diagonal(Sn,sn)

# wykres osypiska
plt.figure(figsize=(12,4))
plt.plot(sn[:30],'ks-',markersize=10)
plt.xlabel('Numer składowej')
plt.ylabel('Wartość osobliwa')
plt.title('Wykres osypiska dla rysunku Strawinskiego')
plt.grid()
plt.show()

fig = plt.figure(figsize=(9,9))
gs = GridSpec(3,4,figure=fig)

# obrazek
ax1 = fig.add_subplot(gs[0,0])
ax1.imshow(stravNoise,cmap='gray')
ax1.set_title(f'Rozmiar macierzy:\n{strav.shape},\nrząd: {np.linalg.matrix_rank(stravNoise)}')

# wykres osypiska
ax2 = fig.add_subplot(gs[0,1:])
ax2.plot(sn[:30],'ks-',markersize=10)
ax2.set_xlabel('Numer składowej')
ax2.set_ylabel('Wartość osobliwa')
ax2.set_title('Wykres osypiska dla rysunku Strawinskiego')
ax2.grid()


## wyświetlam osobno pierwsze N "warstw"
numLayers = 4
rank1mats = np.zeros((numLayers,strav.shape[0],strav.shape[1]))


# pętla
for i in range(numLayers):

    # tworzę warstwę
    rank1mats[i,:,:] = np.outer(Un[:,i],Vtn[i,:])*sn[i]

    # wyświetlam warstwę
    ax = fig.add_subplot(gs[1,i])
    ax.imshow(rank1mats[i,:,:],cmap='gray')
    ax.set_title(f'L {i}')
    ax.set_xticks([]), ax.set_yticks([])

    # wyświetla skumulowaną sumę warstw
    ax = fig.add_subplot(gs[2,i])
    ax.imshow(np.sum(rank1mats[:i+1,:,:],axis=0),cmap='gray')
    ax.set_title(f'L 0:{i}')
    ax.set_xticks([]), ax.set_yticks([])


plt.tight_layout()
plt.savefig('rys15.13.png',dpi=300)
plt.show()



"""# Ćwiczenie 14."""

# rekonstrukcja na podstawie pierwszych k warstw

# składowe szumu
noiseComps = np.array([1,2])

# rekonstrukcja szumu
stravRecNoise = Un[:,noiseComps] @ Sn[noiseComps,:][:,noiseComps] @ Vtn[noiseComps,:]


# rekonstrukcja zaszumionego obrazka
noNoiseCompsU = np.full(Un.shape[0],True)
noNoiseCompsU[noiseComps] = False

noNoiseCompsV = np.full(Vtn.shape[0],True)
noNoiseCompsV[noiseComps] = False

# składowe opisujące obrazek bez szumów
stravRecNoNoise = Un[:,noNoiseCompsU] @ Sn[noNoiseCompsU,:][:,noNoiseCompsV] @ Vtn[noNoiseCompsV,:]




# wykres
_,axs = plt.subplots(1,3,figsize=(15,6))

axs[0].imshow(stravNoise,cmap='gray')
axs[0].set_title('Zaszumiony obrazek')

axs[1].imshow(stravRecNoise,cmap='gray',vmin=-.5,vmax=.5)
axs[1].set_title(f'Sam szum (składowe {noiseComps})')

axs[2].imshow(stravRecNoNoise,cmap='gray',vmin=.1,vmax=.9)
axs[2].set_title('Obrazek po usunięciu szumu')

plt.tight_layout()
plt.savefig('rys15.14.png',dpi=300)
plt.show()

# histogram
plt.hist(stravRecNoise.flatten(),100);

